package eu.dnetlib.msro.workflows.nodes.collect;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.misc.FindWfLatestSuccessDateJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindDateRangeForIncrementalHarvestingJobNode extends FindWfLatestSuccessDateJobNode {

	private static final Log log = LogFactory.getLog(FindDateRangeForIncrementalHarvestingJobNode.class);

	@Override
	protected String execute(final Env env) throws Exception {
		final String fromDate = calculateFromDate();
		log.info("Incremental Harv Details - from: " + fromDate);
		if (fromDate != null) {
			env.setAttribute(getDateParam(), fromDate);
		}
		return Arc.DEFAULT_ARC;
	}

	private String calculateFromDate() {
		final long d = findLastSuccessStartDate();
        LocalDateTime zdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(d), ZoneId.of("Etc/UTC"));
        zdt = zdt.minusHours(6);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").format(zdt);
    }



}
