package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.comparators.HandledDatastructuresComparator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.MDStoreService;

public class CreateMDStoreJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(CreateMDStoreJobNode.class);

	private String format;
	private String layout;
	private String interpretation;
	private String outputPrefix = "mdstore";

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(MDStoreService.class, new HandledDatastructuresComparator());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) {
		log.info("preparing blackboard job: " + getFormat());

		job.setAction("CREATE");
		job.getParameters().put("format", getFormat());
		job.getParameters().put("interpretation", getInterpretation());
		job.getParameters().put("layout", getLayout());
	}

	public String getFormat() {
		return this.format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getInterpretation() {
		return this.interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getLayout() {
		return this.layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getOutputPrefix() {
		return this.outputPrefix;
	}

	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(getOutputPrefix() + "format", CreateMDStoreJobNode.this.format);
				env.setAttribute(getOutputPrefix() + "layout", CreateMDStoreJobNode.this.layout);
				env.setAttribute(getOutputPrefix() + "interpretation", CreateMDStoreJobNode.this.interpretation);
				env.setAttribute(getOutputPrefix() + "id", responseParams.get("id"));
			}
		};
	}

}
