/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJobNode
extends ProcessNode {
    private static final Log log = LogFactory.getLog(SimpleJobNode.class);

    protected void doExecute(Token token) {
        try {
            log.debug((Object)("START NODE: " + this.getBeanName()));
            this.beforeStart(token);
            String arc = this.execute(token.getEnv());
            this.beforeCompleted(token);
            log.debug((Object)("END NODE (SUCCESS): " + this.getBeanName()));
            token.release(arc);
        }
        catch (Throwable e) {
            log.error((Object)"got exception while executing workflow node", e);
            log.debug((Object)("END NODE (FAILED): " + this.getBeanName()));
            this.beforeFailed(token);
            token.releaseAsFailed(e);
        }
    }

    protected abstract String execute(Env var1) throws Exception;

    protected void beforeStart(Token token) {
    }

    protected void beforeCompleted(Token token) {
    }

    protected void beforeFailed(Token token) {
    }
}

