package eu.dnetlib.msro.logging;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;

public interface DnetLoggerDao {

	void init(final String collection);

	void writeLog(final String collection, final Map<String, Object> map);

	void configureIndex(final String collection, final Map<String, IndexConf> indexConf);

	Iterator<Map<String, String>> obtainLogIterator(final String collection);

	Map<String, String> findOne(final String collection, final String key, final String value);

	Map<String, String> findOne(final String collection, final Map<String, Object> criteria);

	Iterator<Map<String, String>> find(final String collection, final String key, final String value);

	Iterator<Map<String, String>> find(final String collection, final Map<String, Object> criteria);

	Iterator<Map<String, String>> findByDateRange(final String collection,
			final LocalDateTime startDate,
			final LocalDateTime endDate,
			final String key,
			final String value);

	Iterator<Map<String, String>> findByDateRange(final String collection, final LocalDateTime startDate, final LocalDateTime endDate);

	Iterator<Map<String, String>> findByDateRange(final String name,
			final LocalDateTime startDate,
			final LocalDateTime endDate,
			final Map<String, Object> criteria);
}
