/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.ObjectStoreService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateObjectStoreJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(CreateObjectStoreJobNode.class);
    private String interpretation;
    private String outputPrefix = "objectStore_";
    private boolean createOnlyIfMissing = false;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(ObjectStoreService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) {
        log.info((Object)"preparing blackboard job for the creation of the objectStore ");
        String basePath = token.getEnv().getAttribute("objectStoreBasePath", String.class);
        job.setAction("CREATE");
        job.getParameters().put("interpretation", this.interpretation);
        job.getParameters().put("createOnlyIfMissing", "" + this.createOnlyIfMissing);
        if (StringUtils.isNotBlank((CharSequence)basePath)) {
            job.getParameters().put("basePath", basePath);
        }
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public boolean isCreateOnlyIfMissing() {
        return this.createOnlyIfMissing;
    }

    public void setCreateOnlyIfMissing(boolean createOnlyIfMissing) {
        this.createOnlyIfMissing = createOnlyIfMissing;
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            @Override
            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute(CreateObjectStoreJobNode.this.getOutputPrefix() + "interpretation", CreateObjectStoreJobNode.this.interpretation);
                env.setAttribute(CreateObjectStoreJobNode.this.getOutputPrefix() + "id", responseParams.get("objectStoreId"));
            }
        };
    }
}

