/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.misc;

import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindWfLatestSuccessDateJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(FindWfLatestSuccessDateJobNode.class);
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    private WorkflowProcess process;
    private String dateParam;

    @Override
    protected String execute(Env env) throws Exception {
        long date = this.findLastSuccessStartDate();
        env.setAttribute(this.getDateParam(), date);
        return Arc.DEFAULT_ARC;
    }

    protected long findLastSuccessStartDate() {
        long res = -1L;
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("system:wfName", this.process.getName());
        query.put("datasource:interface", this.process.getDsInterface());
        query.put("system:processStatus", "SUCCESS");
        Map<String, String> map = this.dnetLogger.findOne(query);
        if (map != null && !map.isEmpty()) {
            res = NumberUtils.toLong((String)map.get("system:startDate"), (long)-1L);
            log.debug((Object)("Latest success date for wf " + this.process.getName() + " for api " + this.process.getDsInterface() + " is " + res));
        }
        return res;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    public DnetLogger getDnetLogger() {
        return this.dnetLogger;
    }

    public void setDnetLogger(DnetLogger dnetLogger) {
        this.dnetLogger = dnetLogger;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public String getDateParam() {
        return this.dateParam;
    }

    public void setDateParam(String dateParam) {
        this.dateParam = dateParam;
    }
}

