package eu.dnetlib.msro.workflows.nodes.objectStore;

import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MetadataObjectRecord;
import eu.dnetlib.rmi.data.ObjectStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class DownloadIntoObjectStoreJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(DownloadIntoObjectStoreJobNode.class);
	private String eprParam;
	private String objectStoreId;
	private String idXpath; // "//*[local-name()='objIdentifier']
	private String contentDescription;
	private String objectIsInsideEpr;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ObjectStoreService.class);
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getObjectStoreId() {
		return this.objectStoreId;
	}

	public void setObjectStoreId(final String objectStoreId) {
		this.objectStoreId = objectStoreId;
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {

		job.setAction("FEEDOBJECT");
		final ResultSet<?> rsIn = token.getEnv().getAttribute(getEprParam(), ResultSet.class);
		job.getParameters().put("obsID", getObjectStoreId());
		job.getParameters().put("mime", getContentDescription());
		final Iterator<String> client = this.resultSetClient.iter(rsIn, String.class).iterator();

		final ResultSet<String> rsOut = this.resultSetFactory.createResultSet(() -> {
			return new MetadataObjectIterator(client, "//*[local-name()='objIdentifier']", "xml");
		});

		token.setProgressProvider(new ResultsetProgressProvider(rsOut, this.resultSetClient));

		job.getParameters().put("epr", rsOut.toJson());
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				log.info("Number of stored records: " + responseParams.get("total"));
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", responseParams.get("total"));
			}
		};
	}

	public String getObjectIsInsideEpr() {
		return this.objectIsInsideEpr;
	}

	public void setObjectIsInsideEpr(final String objectIsInsideEpr) {
		this.objectIsInsideEpr = objectIsInsideEpr;
	}

	public String getIdXpath() {
		return this.idXpath;
	}

	public void setIdXpath(final String idXpath) {
		this.idXpath = idXpath;
	}

	public String getContentDescription() {
		return this.contentDescription;
	}

	public void setContentDescription(final String contentDescription) {
		this.contentDescription = contentDescription;
	}

	class MetadataObjectIterator implements Iterator<String> {

		private final Iterator<String> inputIterator;

		private String mime;

		public MetadataObjectIterator(final Iterator<String> inputIterator, final String xpath, final String mime) {
			this.inputIterator = inputIterator;
		}

		@Override
		public boolean hasNext() {
			return this.inputIterator.hasNext();
		}

		@Override
		public String next() {
			try {
				final String record = this.inputIterator.next();
				final XPath xpath = XPathFactory.newInstance().newXPath();
				final InputSource doc = new InputSource(new StringReader(record));
				final String identifier = xpath.evaluate(getIdXpath(), doc);
				final MetadataObjectRecord objectrecord = new MetadataObjectRecord(identifier, record, this.mime);
				return objectrecord.toJSON();
			} catch (final Exception e) {
				return null;
			}
		}

		@Override
		public void remove() {

		}

	}

}
