/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.unpack;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class UnpackJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(UnpackJobNode.class);
    private String inputEprParam;
    private String outputEprParam;
    private String xpath;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String execute(Env env) throws Exception {
        ResultSet inputRs = env.getAttribute(this.inputEprParam, ResultSet.class);
        final Iterator client = this.resultSetClient.iter(inputRs, String.class).iterator();
        final PriorityBlockingQueue<String> queue = new PriorityBlockingQueue<String>();
        while (queue.isEmpty() && client.hasNext()) {
            this.populateQueue(queue, (String)client.next(), this.xpath);
        }
        ResultSet rs = this.resultSetFactory.createResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        Queue queue = queue;
                        synchronized (queue) {
                            return !queue.isEmpty();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String next() {
                        Queue queue = queue;
                        synchronized (queue) {
                            String res = (String)queue.poll();
                            while (queue.isEmpty() && client.hasNext()) {
                                UnpackJobNode.this.populateQueue(queue, (String)client.next(), UnpackJobNode.this.xpath);
                            }
                            return res;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        });
        env.setAttribute(this.outputEprParam, rs);
        return Arc.DEFAULT_ARC;
    }

    private void populateQueue(Queue<String> queue, String record, String xpath) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(record));
            for (Object o : doc.selectNodes(xpath)) {
                queue.add(((Node)o).asXML());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error unpacking record: \n" + record), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }
}

