/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.provision.IndexService;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public class UpdateIndexJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(UpdateIndexJobNode.class);
    private String eprParam;
    private String indexId;
    private String format;
    @Value(value="${service.index.default.interpretation}")
    private String interpretation;
    private String layout;
    private String feedingType;
    private String defaultIndexId;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private TransformerFactory saxonTransformerFactory;
    @Value(value="${service.index.layoutToRecordStylesheet}")
    private Resource layoutToRecordStylesheet;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(IndexService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws ResultSetException, ISLookUpException, IOException, TransformerException {
        log.info((Object)("preparing blackboard job update index: " + this.getIndexId()));
        ResultSet rs = token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        ResultSet<String> mappedRs = this.prepareForIndexing(rs, this.getFormat(), this.getInterpretation(), this.getLayout());
        token.setProgressProvider(new ResultsetProgressProvider(mappedRs, this.resultSetClient));
        job.setAction("FEED");
        job.getParameters().put("resultset_epr", mappedRs.toJson());
        job.getParameters().put("id", this.getIndexId());
        job.getParameters().put("feeding_type", this.getFeedingType());
        job.getParameters().put("backend_Id", this.defaultIndexId);
    }

    protected ResultSet<String> prepareForIndexing(ResultSet<?> resultSet, String format, String interpretation, String layout) throws ISLookUpException, IOException, TransformerException {
        log.info((Object)("Using layout to record stylesheet: " + this.getLayoutToRecordStylesheet().getURI()));
        Transformer layoutTransformer = this.saxonTransformerFactory.newTransformer(new StreamSource(this.getLayoutToRecordStylesheet().getInputStream()));
        DOMResult layoutToXsltXslt = new DOMResult();
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format, interpretation, layout))), layoutToXsltXslt);
        this.dumpXslt(layoutToXsltXslt);
        return this.resultSetFactory.xsltMap(resultSet, new DOMSource(layoutToXsltXslt.getNode()));
    }

    private String getLayoutSource(String format, String interpretation, String layout) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + format + "' and .//INTERPRETATION='" + interpretation + "']//LAYOUT[@name='" + layout + "']");
    }

    private void dumpXslt(DOMResult layoutToXsltXslt) throws TransformerConfigurationException, TransformerException {
        if (log.isDebugEnabled()) {
            StringWriter buffer = new StringWriter();
            this.saxonTransformerFactory.newTransformer().transform(new DOMSource(layoutToXsltXslt.getNode()), new StreamResult(buffer));
            log.debug((Object)buffer.toString());
        }
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            @Override
            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:indexed", responseParams.get("added"));
                env.setAttribute("mainlog:skipped", responseParams.get("skipped"));
                env.setAttribute("mainlog:marked", responseParams.get("marked"));
                env.setAttribute("mainlog:time", responseParams.get("time"));
            }
        };
    }

    public String getIndexId() {
        return this.indexId;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getFeedingType() {
        return this.feedingType;
    }

    public void setFeedingType(String feedingType) {
        this.feedingType = feedingType;
    }

    public Resource getLayoutToRecordStylesheet() {
        return this.layoutToRecordStylesheet;
    }

    public void setLayoutToRecordStylesheet(Resource layoutToRecordStylesheet) {
        this.layoutToRecordStylesheet = layoutToRecordStylesheet;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getDefaultIndexId() {
        return this.defaultIndexId;
    }

    @Required
    public void setDefaultIndexId(String defaultIndexId) {
        this.defaultIndexId = defaultIndexId;
    }
}

