package eu.dnetlib.msro.workflows.nodes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.msro.workflows.util.SubWorkflowProgressProvider;

/**
 * Created by michele on 18/11/15.
 */
public class LaunchWorkflowJobNode extends ProcessNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(LaunchWorkflowJobNode.class);
	private String wfId;

	@Autowired
	private WorkflowExecutor executor;

	@Autowired
	private ProcessRegistry processRegistry;

	private WorkflowProcess process;

	@Override
	public final void execute(final Token token) {

		try {
			final String procId = executor.startWorkflow(getWfId(), new ProcessCallback() {

				@Override
				public void onSuccess() {
					log.debug("Child workflow has been completed successfully");
					token.setNextArc(Arc.DEFAULT_ARC);
					token.release();
				}

				@Override
				public void onFail() {
					log.error("Child workflow is failed");
					token.releaseAsFailed("Child workflow is failed");
				}
			}, process.getProfileId());

			if (log.isDebugEnabled()) {
				log.debug("The child workflow [" + getWfId() + "] is starting with procId: " + procId);
			}

			token.setProgressProvider(new SubWorkflowProgressProvider(procId, processRegistry));

		} catch (final Throwable e) {
			log.error("got exception while launching child workflow", e);
			token.releaseAsFailed(e);
		}
	}

	public String getWfId() {
		return wfId;
	}

	public void setWfId(final String wfId) {
		this.wfId = wfId;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}

}
