package eu.dnetlib.msro.workflows.nodes.objectStore;

import java.util.function.Function;
import java.util.stream.StreamSupport;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.download.UrlExtractor;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

// TODO: Auto-generated Javadoc

/**
 * The Class RetrieveURLSJobNode.
 */
public class RetrieveURLSJobNode extends SimpleJobNode {

	/**
	 * The epr param.
	 */
	private String inputEprParam;

	/**
	 * The output epr param.
	 */
	private String outputEprParam;

	/**
	 * The xpath.
	 */
	private String xpath;

	/**
	 * The xpath metadata id.
	 */
	private String xpathMetadataId;

	/**
	 * The xpath open access.
	 */
	private String xpathOpenAccess;

	/**
	 * The xpath embargo date.
	 */
	private String xpathEmbargoDate;

	/**
	 * The result set factory.
	 */
	@Autowired
	private ResultSetFactory resultSetFactory;
	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
		final Iterable<String> input = this.resultSetClient.iter(rsIn, String.class);

		final Function<String, String> mapper = new UrlExtractor(this.xpath, this.xpathMetadataId, this.xpathOpenAccess, this.xpathEmbargoDate);

		final ResultSet<String> rsUrls = this.resultSetFactory.createResultSet(() -> StreamSupport.stream(input.spliterator(), false).map(mapper).iterator());;

		env.setAttribute(getOutputEprParam(), rsUrls);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the xpath.
	 *
	 * @return the xpath
	 */
	public String getXpath() {
		return this.xpath;
	}

	/**
	 * Sets the xpath.
	 *
	 * @param xpath
	 *            the xpath to set
	 */
	public void setXpath(final String xpath) {
		this.xpath = xpath;
	}

	/**
	 * Gets the xpath metadata id.
	 *
	 * @return the xpathMetadataId
	 */
	public String getXpathMetadataId() {
		return this.xpathMetadataId;
	}

	/**
	 * Sets the xpath metadata id.
	 *
	 * @param xpathMetadataId
	 *            the xpathMetadataId to set
	 */
	@Required
	public void setXpathMetadataId(final String xpathMetadataId) {
		this.xpathMetadataId = xpathMetadataId;
	}

	/**
	 * Gets the output epr param.
	 *
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	/**
	 * Sets the output epr param.
	 *
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	/**
	 * Gets the input epr param.
	 *
	 * @return the inputEprParam
	 */
	public String getInputEprParam() {
		return this.inputEprParam;
	}

	/**
	 * Sets the input epr param.
	 *
	 * @param inputEprParam
	 *            the inputEprParam to set
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	/**
	 * Gets the xpath open access.
	 *
	 * @return the xpath open access
	 */
	public String getXpathOpenAccess() {
		return this.xpathOpenAccess;
	}

	/**
	 * Sets the xpath open access.
	 *
	 * @param xpathOpenAccess
	 *            the new xpath open access
	 */
	public void setXpathOpenAccess(final String xpathOpenAccess) {
		this.xpathOpenAccess = xpathOpenAccess;
	}

	/**
	 * Gets the xpath embargo date.
	 *
	 * @return the xpath embargo date
	 */
	public String getXpathEmbargoDate() {
		return this.xpathEmbargoDate;
	}

	/**
	 * Sets the xpath embargo date.
	 *
	 * @param xpathEmbargoDate
	 *            the new xpath embargo date
	 */
	public void setXpathEmbargoDate(final String xpathEmbargoDate) {
		this.xpathEmbargoDate = xpathEmbargoDate;
	}

}
