package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 13/07/16.
 */
public abstract class AbstractJobNode extends ProcessNode {

	private static final Log log = LogFactory.getLog(SimpleJobNode.class);

	protected void doExecute(final Token token) {
		try {
			log.debug("START NODE: " + getBeanName());
			beforeStart(token);
			final String arc = execute(token.getEnv());
			beforeCompleted(token);
			log.debug("END NODE (SUCCESS): " + getBeanName());

			token.release(arc);

		} catch (Throwable e) {
			log.error("got exception while executing workflow node", e);
			log.debug("END NODE (FAILED): " + getBeanName());
			beforeFailed(token);
			token.releaseAsFailed(e);
		}
	}

	abstract protected String execute(final Env env) throws Exception;

	protected void beforeStart(final Token token) {
		// For optional overwrites
	}

	protected void beforeCompleted(final Token token) {
		// For optional overwrites
	}

	protected void beforeFailed(final Token token) {
		// For optional overwrites
	}

}
