package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.List;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMultipleMDStores extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchMultipleMDStores.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private List<String> mdId;

	private String eprParam;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String execute(final Env env) throws Exception {

		if (getMdId() == null) {
			final String mdIdsJson = env.getAttribute("mdId", String.class);
			@SuppressWarnings("unchecked")
			final List<String> mdIds = new Gson().fromJson(mdIdsJson, List.class);
			log.info(String.format("fetching records for %s mdstores", mdIds.size()));
			if (log.isDebugEnabled()) {
				log.debug(String.format("fetching records for mdstores: %s", mdIdsJson));
			}
			setMdId(mdIds);
		}

		final MultipleMdStoreIterable iter = new MultipleMdStoreIterable(this.serviceLocator, getMdId(), this.resultSetClient);
		final ResultSet<String> rs = this.resultSetFactory.createResultSet(iter);
		env.setAttribute(getEprParam(), rs);

		return Arc.DEFAULT_ARC;
	}

	public List<String> getMdId() {
		return this.mdId;
	}

	public void setMdId(final List<String> mdId) {
		this.mdId = mdId;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
