package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.Iterator;
import java.util.List;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;

// TODO: Auto-generated Javadoc
/**
 * The Class MultipleMdStoreIterable.
 */
public class MultipleMdStoreIterable implements Iterable<String> {

	/** The service locator. */
	private final UniqueServiceLocator serviceLocator;

	/** The md ids. */
	private final List<String> mdIds;

	private final ResultSetClient resultSetClient;

	/**
	 * Instantiates a new multiple md store iterable.
	 *
	 * @param serviceLocator
	 *            the service locator
	 * @param mdIds
	 *            the md ids
	 */
	public MultipleMdStoreIterable(final UniqueServiceLocator serviceLocator, final List<String> mdIds, final ResultSetClient resultSetClient) {
		super();
		this.serviceLocator = serviceLocator;
		this.mdIds = mdIds;
		this.resultSetClient = resultSetClient;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Iterable#iterator()
	 */
	@Override
	public Iterator<String> iterator() {
		return new MultipleMdStoreIterator(this.serviceLocator, this.mdIds, this.resultSetClient);
	}
}
