/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.oai;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareOaiDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String oaiDbName;
    private String oaiFormat;
    private String oaiLayout;
    private String oaiInterpretation;
    private String oaiSource;

    @Override
    protected String execute(Env env) throws Exception {
        log.info((Object)"start preparing job");
        this.setIfNotBlank(OAIParameterNames.OAI_DB, this.oaiDbName, env);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_NAME, this.oaiFormat, env);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_LAYOUT, this.oaiLayout, env);
        this.setIfNotBlank(OAIParameterNames.OAI_FORMAT_INTERPRETATION, this.oaiInterpretation, env);
        this.setIfNotBlank(OAIParameterNames.OAI_COLLECTON, this.oaiFormat + "-" + this.oaiLayout + "-" + this.oaiInterpretation, env);
        String configurationProfile = this.getConfigurationProfile();
        this.setIfNotBlank(OAIParameterNames.OAI_CONFIGURATION_PROFILE, configurationProfile, env);
        return Arc.DEFAULT_ARC;
    }

    private void setIfNotBlank(String attrName, String attrValue, Env env) {
        if (StringUtils.isNotBlank((CharSequence)attrValue)) {
            env.setAttribute(attrName, attrValue);
        }
    }

    private String getConfigurationProfile() throws MSROException {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
        }
        catch (Exception e) {
            throw new MSROException("Cannot find OAI configuration profile", (Throwable)e);
        }
    }

    public String getOaiDbName() {
        return this.oaiDbName;
    }

    public void setOaiDbName(String oaiDbName) {
        this.oaiDbName = oaiDbName;
    }

    public String getOaiFormat() {
        return this.oaiFormat;
    }

    public void setOaiFormat(String oaiFormat) {
        this.oaiFormat = oaiFormat;
    }

    public String getOaiLayout() {
        return this.oaiLayout;
    }

    public void setOaiLayout(String oaiLayout) {
        this.oaiLayout = oaiLayout;
    }

    public String getOaiInterpretation() {
        return this.oaiInterpretation;
    }

    public void setOaiInterpretation(String oaiInterpretation) {
        this.oaiInterpretation = oaiInterpretation;
    }

    public String getOaiSource() {
        return this.oaiSource;
    }

    public void setOaiSource(String oaiSource) {
        this.oaiSource = oaiSource;
    }
}

