package eu.dnetlib.msro.workflows.nodes.sel;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;

/**
 * The Class SelectiveNode allows to decide which path a workflow must take.
 */
public class SelectiveNode extends SimpleJobNode {

	/**
	 * The selection.
	 */
	private String selection = Arc.DEFAULT_ARC;

	@Override
	protected String execute(final Env env) throws Exception {
		return selection;
	}

	/**
	 * Gets the selection.
	 *
	 * @return the selection
	 */
	public String getSelection() {
		return selection;
	}

	/**
	 * Sets the selection.
	 *
	 * @param selection the new selection
	 */
	public void setSelection(final String selection) {
		this.selection = selection;
	}

}
