/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectRecordsJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;
    private String fromDate;
    private String untilDate;

    @Override
    protected String execute(Env env) throws Exception {
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(this.datasourceId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");
        InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance((Node)ifcNode);
        ResultSet rs = ((CollectorService)this.serviceLocator.getService(CollectorService.class)).dateRangeCollect(interfaceDescriptor, this.fromDate, this.untilDate);
        env.setAttribute(this.getEprParam(), rs);
        return Arc.DEFAULT_ARC;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(String untilDate) {
        this.untilDate = untilDate;
    }
}

