package eu.dnetlib.msro.logging;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class DnetLogger implements Iterable<Map<String, String>> {

	private String name;

	private Resource indexConf;

	@javax.annotation.Resource
	private DnetLoggerDao dao;

	@PostConstruct
	public void init() {
		dao.init(name);
		dao.configureIndex(name, DnetLogConfigurationLoader.getIndexedPaths(indexConf));
	}

	public LogMessage newLogMessage(final DnetLogLevel level) {
		return new LogMessage(dao, name, level);
	}

	public LogMessage newLogMessage() {
		return newLogMessage(DnetLogLevel.INFO);
	}

	public Iterator<Map<String, String>> find(final String key, final String value) {
		return dao.find(name, key, value);
	}

	public Iterator<Map<String, String>> find(final Map<String, Object> criteria) {
		return dao.find(name, criteria);
	}

	public Map<String, String> findOne(final String key, final String value) {
		return dao.findOne(name, key, value);
	}

	public Map<String, String> findOne(final Map<String, Object> criteria) {
		return dao.findOne(name, criteria);
	}

	@Override
	public Iterator<Map<String, String>> iterator() {
		return dao.obtainLogIterator(name);
	}

	public String getName() {
		return name;
	}

	@Required
	public void setName(final String name) {
		this.name = name;
	}

	public Resource getIndexConf() {
		return indexConf;
	}

	public void setIndexConf(final Resource indexConf) {
		this.indexConf = indexConf;
	}

	public Iterator<Map<String, String>> range(final LocalDateTime startDate, final LocalDateTime endDate) {
		return dao.findByDateRange(name, startDate, endDate);
	}

	public Iterator<Map<String, String>> range(final LocalDateTime startDate, final LocalDateTime endDate, final String key, final String value) {
		return dao.findByDateRange(name, startDate, endDate, key, value);
	}

	public Iterator<Map<String, String>> range(final LocalDateTime startDate, final LocalDateTime endDate, final Map<String, Object> criteria) {
		return dao.findByDateRange(name, startDate, endDate, criteria);
	}

}
