/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecuteSqlJobNode
extends AsyncJobNode {
    private String db;
    private String dbParam;
    private String sql;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(Env env) throws Exception {
        ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).updateSQL(this.findDb(env), this.fetchSqlAsText(this.sql));
        return Arc.DEFAULT_ARC;
    }

    private String fetchSqlAsText(String path) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path), (Charset)Charset.forName("UTF-8"));
    }

    private String findDb(Env env) {
        if (this.dbParam != null && !this.dbParam.isEmpty()) {
            return env.getAttribute(this.dbParam, String.class);
        }
        return this.db;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

