/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.transform.GroovyUnaryFunction;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GroovyJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(GroovyJobNode.class);
    @Autowired
    private ResultSetFactory resultSetFactory;
    private String inputEprParam;
    private String outputEprParam;
    private String transformationRuleId;
    private Map<String, String> groovyParams;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    private Map<String, String> retrieveGroovyParameter() {
        HashMap out = Maps.newHashMap();
        String query = "for $x in collection('/db/DRIVER/GroovyProcessingDSResource/GroovyProcessingDSResourceType')where $x[.//RESOURCE_IDENTIFIER/@value='" + this.transformationRuleId + "']return concat($x//GROOVY_CLASSPATH/text(),':::',$x//GROOVY_DNETCLASS/text())";
        try {
            String result = (String)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query).get(0);
            if (result == null) {
                return null;
            }
            String[] data = result.trim().split(":::");
            if (data.length == 2) {
                out.put("classpath", data[0]);
                out.put("mainClass", data[1]);
            }
            return out;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    protected String execute(Env env) throws Exception {
        ResultSet rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        Map<String, String> prop = this.retrieveGroovyParameter();
        String groovyClasspath = prop.get("classpath");
        String groovyDnetClass = prop.get("mainClass");
        ResultSet<?> rsOut = this.transformGroovy(rsIn, groovyClasspath, groovyDnetClass, this.groovyParams);
        env.setAttribute(this.outputEprParam, rsOut);
        return Arc.DEFAULT_ARC;
    }

    private ResultSet<?> transformGroovy(ResultSet<?> source, String groovyClasspath, String groovyDnetClass, Map<String, String> params) throws ClassNotFoundException, IOException {
        GroovyScriptEngine gse = new GroovyScriptEngine(groovyClasspath);
        gse.getGroovyClassLoader().loadClass(groovyDnetClass);
        log.info((Object)"***********************************************");
        log.info((Object)"Loaded Groovy classes:");
        for (Class c : gse.getGroovyClassLoader().getLoadedClasses()) {
            log.info((Object)c.getCanonicalName());
        }
        log.info((Object)"***********************************************");
        GroovyShell groovyShell = new GroovyShell((ClassLoader)gse.getGroovyClassLoader());
        Object go = groovyShell.evaluate("new " + groovyDnetClass + "()");
        if (go instanceof GroovyUnaryFunction) {
            GroovyUnaryFunction groovyUnaryFunction = (GroovyUnaryFunction)go;
            if (params != null) {
                groovyUnaryFunction.setParams(params);
            }
            return this.resultSetFactory.map(source, String.class, (Function)groovyUnaryFunction);
        }
        throw new RuntimeException("Groovy object " + go + " is not supported");
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getTransformationRuleId() {
        return this.transformationRuleId;
    }

    public void setTransformationRuleId(String transformationRuleId) {
        this.transformationRuleId = transformationRuleId;
    }

    public Map<String, String> getGroovyParams() {
        return this.groovyParams;
    }

    public void setGroovyParams(Map<String, String> groovyParams) {
        this.groovyParams = groovyParams;
    }
}

