package eu.dnetlib.msro.workflows.nodes.oai;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * The Class PrepareOaiDataJobNode.
 */
public class SetCurrentOAIDBJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(SetCurrentOAIDBJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Autowired
	private UniqueServiceLocator serviceLocator;

	// overrides the value in the env param
	private String oaiDbName;

	private String xpathToCurrentDB = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/CURRENTDB";

	protected String getTheOAIDBName(final Env env) {
		return StringUtils.isNotBlank(oaiDbName)? oaiDbName : env.getAttribute(OAIParameterNames.OAI_DB, String.class);
	}


	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {
		String dbToSet = getTheOAIDBName(env);
		log.fatal("Setting OAI Publisher to use db " + dbToSet);
		String xUpdate = "update value " + xpathToCurrentDB + " with '" + dbToSet + "'";
		this.serviceLocator.getService(ISRegistryService.class).executeXUpdate(xUpdate);
		return Arc.DEFAULT_ARC;
	}

	public String getOaiDbName() {
		return oaiDbName;
	}

	public void setOaiDbName(final String oaiDbName) {
		this.oaiDbName = oaiDbName;
	}

	public String getXpathToCurrentDB() {
		return xpathToCurrentDB;
	}

	public void setXpathToCurrentDB(final String xpathToCurrentDB) {
		this.xpathToCurrentDB = xpathToCurrentDB;

	}

}
