/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.download;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadFromMetadataJobNode
extends BlackboardJobNode {
    protected String regularExpression;
    private String inputeprParam;
    private String objectStoreID;
    private String plugin;
    private String protocol;
    private String mimeType;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(ObjectStoreService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        job.setAction("DOWNLOAD");
        ResultSet rs = token.getEnv().getAttribute(this.getInputeprParam(), ResultSet.class);
        token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));
        job.getParameters().put("epr", rs.toJson());
        job.getParameters().put("protocol", this.getProtocol());
        job.getParameters().put("plugin", this.getPlugin());
        job.getParameters().put("mimeType", this.getMimeType());
        job.getParameters().put("objectStoreID", this.getObjectStoreID());
        if (!StringUtils.isEmpty((CharSequence)this.getRegularExpression())) {
            job.getParameters().put("regularExpressions", this.getRegularExpression());
        }
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            @Override
            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", responseParams.get("total"));
            }
        };
    }

    public String getInputeprParam() {
        return this.inputeprParam;
    }

    public void setInputeprParam(String inputeprParam) {
        this.inputeprParam = inputeprParam;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protol) {
        this.protocol = protol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }
}

