/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.oai;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.oai.AbstractOAIJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.common.ResultSetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncOAIStoreJobNode
extends AbstractOAIJobNode {
    private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class);
    private String eprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private boolean alwaysNewRecord = false;
    private boolean skipDuplicates = false;
    private String duplicateXPath;

    @Override
    void completePrepareJob(BlackboardJob job, Token token) throws ResultSetException {
        ResultSet rs = token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));
        job.setAction("SYNC");
        job.getParameters().put(OAIParameterNames.OAI_FEED_DATE, DateUtils.now_ISO8601());
        job.getParameters().put(OAIParameterNames.OAI_SKIP_DUPLICATES, String.valueOf(this.skipDuplicates));
        if (this.skipDuplicates) {
            job.getParameters().put(OAIParameterNames.OAI_DUPLICATE_XPATH, this.duplicateXPath);
        }
        job.getParameters().put(OAIParameterNames.OAI_SYNC_EPR, rs.toJson());
        job.getParameters().put(OAIParameterNames.OAI_ALWAYS_NEW_RECORD, String.valueOf(this.alwaysNewRecord));
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String getDuplicateXPath() {
        return this.duplicateXPath;
    }

    public void setDuplicateXPath(String duplicateXPath) {
        this.duplicateXPath = duplicateXPath;
    }
}

