package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.data.MDStoreService;

public class StoreMDStoreRecordsJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(StoreMDStoreRecordsJobNode.class);

	private String eprParam;
	private String mdId;
	private String storingType;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(MDStoreService.class, this.mdId);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws ResultSetException {
		final ResultSet<?> rs = token.getEnv().getAttribute(getEprParam(), ResultSet.class);

		token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));

		job.setAction("FEED");
		job.getParameters().put("epr", rs.toJson());
		job.getParameters().put("storingType", getStoringType());
		job.getParameters().put("mdId", getMdId());
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				log.info("New mdstore size : " + responseParams.get("mdstoreSize"));
				log.info("Number of write operations: " + responseParams.get("writeOps"));
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "sinkSize", responseParams.get("mdstoreSize"));
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "processedSize", responseParams.get("writeOps"));
			}
		};
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getMdId() {
		return this.mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getStoringType() {
		return this.storingType;
	}

	public void setStoringType(final String storingType) {
		this.storingType = storingType;
	}

}
