package eu.dnetlib.msro.workflows.nodes.transform;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CleanerService;
import org.springframework.beans.factory.annotation.Autowired;

public class CleanJobNode extends SimpleJobNode {

	private String inputEprParam;
	private String outputEprParam;
	private String ruleId;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		@SuppressWarnings("unchecked")
		final ResultSet<String> rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
		final ResultSet<String> rsOut =
				this.ruleId == null || this.ruleId.isEmpty() ? rsIn : this.serviceLocator.getService(CleanerService.class).clean(rsIn, this.ruleId);

		env.setAttribute(this.outputEprParam, rsOut);

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getRuleId() {
		return this.ruleId;
	}

	public void setRuleId(final String ruleId) {
		this.ruleId = ruleId;
	}

}
