package eu.dnetlib.msro.workflows.nodes;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncJobNode extends AbstractJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(AsyncJobNode.class);

	private final ExecutorService executor = Executors.newCachedThreadPool();

	@Override
	public final void execute(final Token token) {

		log.info("executing async node");

		executor.execute(() -> doExecute(token));
	}

}
