package eu.dnetlib.msro.workflows.nodes;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.msro.workflows.util.SubWorkflowProgressProvider;

/**
 * Created by michele on 12/01/16.
 */
public class LaunchWorkflowTemplateJobNode extends ProcessNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(LaunchWorkflowTemplateJobNode.class);

	private String wfTemplateId;
	private Map<String, String> wfTemplateParams;

	private WorkflowProcess process;

	public Map<String, String> getWfTemplateParams() {
		return wfTemplateParams;
	}

	public void setWfTemplateParams(final Map<String, String> wfTemplateParams) {
		this.wfTemplateParams = wfTemplateParams;
	}

	@Autowired
	private WorkflowExecutor executor;

	@Autowired
	private ProcessRegistry processRegistry;

	@Override
	public final void execute(final Token token) {
		try {
			final String family = process.getFamily();
			final int priority = process.getPriority();
			final String dsId = process.getDsId();
			final String iface = process.getDsInterface();

			final String procId =
					executor.startWorkflowTemplate(getWfTemplateId(), getNodeName(), family, priority, dsId, iface, wfTemplateParams,
							new ProcessCallback() {

								@Override
								public void onSuccess() {
									log.debug("Child workflow has been completed successfully");
									token.setNextArc(Arc.DEFAULT_ARC);
									token.release();
								}

								@Override
								public void onFail() {
									log.error("Child workflow is failed");
									token.releaseAsFailed("Child workflow is failed");
								}
							}, process.getProfileId());
			if (log.isDebugEnabled()) {
				log.debug("The child workflow [" + getNodeName() + "] is starting with procId: " + procId);
			}

			token.setProgressProvider(new SubWorkflowProgressProvider(procId, processRegistry));

		} catch (final Throwable e) {
			log.error("got exception while launching child workflow", e);
			token.releaseAsFailed(e);
		}
	}

	public String getWfTemplateId() {
		return wfTemplateId;
	}

	public void setWfTemplateId(final String wfTemplateId) {
		this.wfTemplateId = wfTemplateId;
	}

	public WorkflowProcess getProcess() {
		return process;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}

}
