package eu.dnetlib.msro.logging;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;

public class DnetLogConfigurationLoader {

	public static Map<String, IndexConf> getIndexedPaths(final Resource indexConf) {
		final Map<String, IndexConf> response = new HashMap<>();
		response.put(LogMessage.LOG_LEVEL_FIELD, null);
		response.put(LogMessage.LOG_DATE_FIELD, null);
		if (indexConf != null) {
			final Config config = loadConfiguration(indexConf);
			if (config != null) {
				for (final Entry<String, ConfigValue> e : config.getObject("dnet.log.index.conf").entrySet()) {
					response.put(e.getKey(), null);
				}
			}
		}
		return response;
	}

	public static final Config loadConfiguration(final Resource resource) {
		if (resource != null) {
			try {
				return ConfigFactory.parseString(IOUtils.toString(resource.getInputStream(), Charset.forName("UTF-8")));
			} catch (final IOException e) {
				return null;
			}
		}
		return null;
	}

}
