/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.graph;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.graph.GraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Graph {
    private final Map<String, GraphNode> nodes = new HashMap<String, GraphNode>();
    private List<Arc> arcs = new ArrayList<Arc>();

    public void addArc(Arc arc) {
        this.arcs.add(arc);
    }

    public void addNode(GraphNode node) {
        this.nodes.put(node.getName(), node);
    }

    public Set<String> nodeNames() {
        return this.nodes.keySet();
    }

    public Collection<GraphNode> nodes() {
        return this.nodes.values();
    }

    public GraphNode getNode(String name) {
        return this.nodes.get(name);
    }

    public List<Arc> getArcs() {
        return this.arcs;
    }

    public void setArcs(List<Arc> arcs) {
        this.arcs = arcs;
    }

    public Set<GraphNode> startNodes() {
        HashSet<GraphNode> res = new HashSet<GraphNode>();
        for (GraphNode n : this.nodes.values()) {
            if (!n.isStart()) continue;
            res.add(n);
        }
        return res;
    }

    public Set<GraphNode> nextNodes(GraphNode current, String arcName) {
        HashSet<GraphNode> res = new HashSet<GraphNode>();
        for (Arc arc : this.arcs) {
            if (!StringUtils.equals((CharSequence)arc.getFrom(), (CharSequence)current.getName()) || !StringUtils.equals((CharSequence)arc.getName(), (CharSequence)arcName)) continue;
            res.add(this.nodes.get(arc.getTo()));
        }
        return res;
    }

    public int getNumberOfIncomingArcs(GraphNode node) {
        int count = 0;
        for (Arc arc : this.arcs) {
            if (!arc.getTo().equals(node.getName())) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "\n************************\nNodes: " + this.nodes + "\nArcs:  " + this.arcs + "\n************************\n";
    }
}

