/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.misc.FindWfLatestSuccessDateJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindDateRangeForIncrementalHarvestingJobNode
extends FindWfLatestSuccessDateJobNode {
    private static final Log log = LogFactory.getLog(FindDateRangeForIncrementalHarvestingJobNode.class);

    @Override
    protected String execute(Env env) throws Exception {
        String fromDate = this.calculateFromDate();
        log.info((Object)("Incremental Harv Details - from: " + fromDate));
        if (fromDate != null) {
            env.setAttribute(this.getDateParam(), fromDate);
        }
        return Arc.DEFAULT_ARC;
    }

    private String calculateFromDate() {
        long d = this.findLastSuccessStartDate();
        LocalDateTime zdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(d), ZoneId.of("Etc/UTC"));
        zdt = zdt.minusHours(6L);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(zdt);
    }
}

