/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryDbJobNode
extends AsyncJobNode {
    private String db;
    private String sql;
    private String sqlForSize;
    private String xslt;
    private String outputEprParam;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(Env env) throws Exception {
        String sqlText = this.fetchSqlAsText(this.sql);
        ResultSet rs = null;
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        if (StringUtils.isNotBlank((CharSequence)this.xslt)) {
            String xsltText = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(this.xslt), (Charset)Charset.forName("UTF-8"));
            rs = StringUtils.isBlank((CharSequence)this.sqlForSize) ? dbService.xsltSearchSQL(this.getDb(), sqlText, xsltText) : dbService.alternativeXsltSearchSQL(this.getDb(), sqlText, this.fetchSqlAsText(this.sqlForSize), xsltText);
        } else {
            rs = StringUtils.isBlank((CharSequence)this.sqlForSize) ? dbService.searchSQL(this.getDb(), sqlText) : dbService.alternativeSearchSQL(this.getDb(), sqlText, this.fetchSqlAsText(this.sqlForSize));
        }
        env.setAttribute(this.outputEprParam, rs);
        return Arc.DEFAULT_ARC;
    }

    private String fetchSqlAsText(String path) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path), (Charset)Charset.forName("UTF-8"));
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getSqlForSize() {
        return this.sqlForSize;
    }

    public void setSqlForSize(String sqlForSize) {
        this.sqlForSize = sqlForSize;
    }
}

