/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.oai;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.provision.OAIStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOAIJobNode
extends BlackboardJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(AbstractOAIJobNode.class);
    private String oaiDbName;
    private String oaiFormat;
    private String oaiLayout;
    private String oaiInterpretation;
    private WorkflowProcess process;

    protected String getTheOAICollection() {
        return this.getOaiFormat() + "-" + this.getOaiLayout() + "-" + this.getOaiInterpretation();
    }

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(OAIStoreService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws ResultSetException {
        job.getParameters().put(OAIParameterNames.OAI_DB, this.getOaiDbName());
        job.getParameters().put(OAIParameterNames.OAI_FORMAT_NAME, this.getOaiFormat());
        job.getParameters().put(OAIParameterNames.OAI_FORMAT_LAYOUT, this.getOaiLayout());
        job.getParameters().put(OAIParameterNames.OAI_FORMAT_INTERPRETATION, this.getOaiInterpretation());
        job.getParameters().put(OAIParameterNames.OAI_COLLECTON, this.getTheOAICollection());
        String theSource = this.process.getDsInterface();
        log.fatal((Object)("OAI Record source is " + theSource));
        job.getParameters().put(OAIParameterNames.OAI_SOURCE, theSource);
        this.completePrepareJob(job, token);
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    abstract void completePrepareJob(BlackboardJob var1, Token var2) throws ResultSetException;

    public String getOaiDbName() {
        return this.oaiDbName;
    }

    public void setOaiDbName(String oaiDbName) {
        this.oaiDbName = oaiDbName;
    }

    public String getOaiFormat() {
        return this.oaiFormat;
    }

    public void setOaiFormat(String oaiFormat) {
        this.oaiFormat = oaiFormat;
    }

    public String getOaiLayout() {
        return this.oaiLayout;
    }

    public void setOaiLayout(String oaiLayout) {
        this.oaiLayout = oaiLayout;
    }

    public String getOaiInterpretation() {
        return this.oaiInterpretation;
    }

    public void setOaiInterpretation(String oaiInterpretation) {
        this.oaiInterpretation = oaiInterpretation;
    }
}

