/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.msro.workflows.util.SubWorkflowProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LaunchWorkflowJobNode
extends ProcessNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(LaunchWorkflowJobNode.class);
    private String wfId;
    @Autowired
    private WorkflowExecutor executor;
    @Autowired
    private ProcessRegistry processRegistry;
    private WorkflowProcess process;

    @Override
    public final void execute(final Token token) {
        try {
            String procId = this.executor.startWorkflow(this.getWfId(), new ProcessCallback(){

                @Override
                public void onSuccess() {
                    log.debug((Object)"Child workflow has been completed successfully");
                    token.setNextArc(Arc.DEFAULT_ARC);
                    token.release();
                }

                @Override
                public void onFail() {
                    log.error((Object)"Child workflow is failed");
                    token.releaseAsFailed("Child workflow is failed");
                }
            }, this.process.getProfileId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("The child workflow [" + this.getWfId() + "] is starting with procId: " + procId));
            }
            token.setProgressProvider(new SubWorkflowProgressProvider(procId, this.processRegistry));
        }
        catch (Throwable e) {
            log.error((Object)"got exception while launching child workflow", e);
            token.releaseAsFailed(e);
        }
    }

    public String getWfId() {
        return this.wfId;
    }

    public void setWfId(String wfId) {
        this.wfId = wfId;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

