package eu.dnetlib.data.actionmanager.actions;

import java.lang.reflect.Type;

import com.google.gson.*;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AbstractActionSerializer;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 30/09/15.
 */
public class AtomicActionDeserialiser extends AbstractActionSerializer implements JsonDeserializer<AtomicAction> {

	private static final Log log = LogFactory.getLog(AtomicActionDeserialiser.class);

	public static AtomicAction fromJSON(String s) {
		final GsonBuilder gson = new GsonBuilder();

		gson.registerTypeAdapter(AtomicAction.class, new AtomicActionDeserialiser());

		return gson.create().fromJson(s, AtomicAction.class);
	}

	@Override
	public AtomicAction deserialize(final JsonElement json, final Type typeOfT, final JsonDeserializationContext context) throws JsonParseException {

		if (json.isJsonObject()) {
			final JsonObject j = (JsonObject) json;

			final Agent a = new Agent();

			final JsonObject aj = j.get(agent).getAsJsonObject();
			a.setId(aj.get(agent_id).getAsString());
			a.setName(aj.get(agent_name).getAsString());
			a.setType(Agent.AGENT_TYPE.valueOf(aj.get(agent_type).getAsString()));

			AtomicAction aa = new AtomicAction(j.get(rawSet).getAsString(), a);

			aa.setTargetColumn(j.get(targetColumn).getAsString());
			aa.setTargetColumnFamily(j.get(targetColumnFamily).getAsString());
			aa.setTargetRowKey(j.get(targetRowKey).getAsString());

			aa.setRowKey(j.get(rowKey).getAsString());
			aa.setTargetValue(decodeTargetValue(j.get(targetValue).getAsString()));

			return aa;
		}

		throw new JsonParseException("input is not a json object");
	}

	private byte[] decodeTargetValue(final String s) {
		try {
			final String json = new String(Base64.decodeBase64(s.getBytes()));

			OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
			JsonFormat.merge(json, oaf);

			return oaf.build().toByteArray();
		} catch (JsonFormat.ParseException e) {
			log.error("unable to parse proto", e);
			return null;
		}
	}

}

