/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.actionmanager.actions;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AbstractActionSerializer;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import java.lang.reflect.Type;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomicActionDeserialiser
extends AbstractActionSerializer
implements JsonDeserializer<AtomicAction> {
    private static final Log log = LogFactory.getLog(AtomicActionDeserialiser.class);

    public static AtomicAction fromJSON(String s) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(AtomicAction.class, (Object)new AtomicActionDeserialiser());
        return (AtomicAction)gson.create().fromJson(s, AtomicAction.class);
    }

    public AtomicAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject j = (JsonObject)json;
            Agent a = new Agent();
            JsonObject aj = j.get("Agent").getAsJsonObject();
            a.setId(aj.get("Agent.Id").getAsString());
            a.setName(aj.get("Agent.name").getAsString());
            a.setType(Agent.AGENT_TYPE.valueOf((String)aj.get("Agent.type").getAsString()));
            AtomicAction aa = new AtomicAction(j.get("RawSet").getAsString(), a);
            aa.setTargetColumn(j.get("TargetColumn").getAsString());
            aa.setTargetColumnFamily(j.get("TargetColumnFamily").getAsString());
            aa.setTargetRowKey(j.get("TargetRowKey").getAsString());
            aa.setRowKey(j.get("RowKey").getAsString());
            aa.setTargetValue(this.decodeTargetValue(j.get("TargetValue").getAsString()));
            return aa;
        }
        throw new JsonParseException("input is not a json object");
    }

    private byte[] decodeTargetValue(String s) {
        try {
            String json = new String(Base64.decodeBase64((byte[])s.getBytes()));
            OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
            JsonFormat.merge((CharSequence)json, (Message.Builder)oaf);
            return oaf.build().toByteArray();
        }
        catch (JsonFormat.ParseException e) {
            log.error((Object)"unable to parse proto", (Throwable)e);
            return null;
        }
    }
}

