/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import java.util.List;
import java.util.Map;

public class OafDecoder {
    private OafProtos.Oaf oaf;
    private OafEntityDecoder entityDecoder = null;
    private OafRelDecoder relDecoder = null;

    public static OafDecoder decode(OafProtos.Oaf oaf) {
        return new OafDecoder(oaf);
    }

    public static OafDecoder decode(byte[] oaf) {
        return new OafDecoder(oaf);
    }

    protected OafDecoder(byte[] value) {
        try {
            this.oaf = OafProtos.Oaf.parseFrom(value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("unable to deserialize proto: " + new String(value));
        }
    }

    private OafDecoder(OafProtos.Oaf oaf) {
        this.oaf = oaf;
    }

    public KindProtos.Kind getKind() {
        return this.oaf.getKind();
    }

    public OafProtos.Oaf getOaf() {
        return this.oaf;
    }

    public GeneratedMessage getMetadata() {
        return this.decodeEntity().getMetadata();
    }

    public GeneratedMessage getOafEntity() {
        return this.decodeEntity().getEntity();
    }

    public String getEntityId() {
        return this.decodeEntity().getId();
    }

    public OafProtos.OafEntity getEntity() {
        return this.oaf.getEntity();
    }

    public OafEntityDecoder decodeEntity() {
        if (this.entityDecoder == null) {
            this.entityDecoder = OafEntityDecoder.decode(this.getEntity());
        }
        return this.entityDecoder;
    }

    public OafProtos.OafRel getOafRel() {
        return this.oaf.getRel();
    }

    public GeneratedMessage getRel() {
        return this.decodeRel().getRel();
    }

    public RelTypeProtos.RelType relType() {
        return this.decodeRel().getRelType();
    }

    public String relTypeName() {
        return this.relType().toString();
    }

    public String relSourceId() {
        return this.decodeRel().getRelSourceId();
    }

    public String relTargetId() {
        return this.decodeRel().getRelTargetId();
    }

    public String getCFQ() {
        switch (this.getKind()) {
            case entity: {
                return this.getEntity().getType().toString();
            }
            case relation: {
                return this.decodeRel().getCFQ();
            }
        }
        throw new IllegalArgumentException("Invalid Kind: " + (Object)((Object)this.getKind()));
    }

    public RelDescriptor getRelDescriptor() {
        if (!this.getKind().equals((Object)KindProtos.Kind.relation)) {
            return null;
        }
        return this.decodeRel().getRelDescriptor();
    }

    private OafRelDecoder decodeRel() {
        if (this.relDecoder == null) {
            this.relDecoder = OafRelDecoder.decode(this.getOafRel());
        }
        return this.relDecoder;
    }

    public byte[] toByteArray() {
        return this.oaf.toByteArray();
    }

    public String asXml() {
        StringBuilder sb = new StringBuilder("<oaf>");
        for (Map.Entry e : this.oaf.getAllFields().entrySet()) {
            this.asXml(sb, (Descriptors.FieldDescriptor)e.getKey(), e.getValue());
        }
        sb.append("</oaf>");
        return sb.toString();
    }

    private void asXml(StringBuilder sb, Descriptors.FieldDescriptor fd, Object value) {
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.asXml(sb, fd, o);
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            sb.append("<" + fd.getName() + ">");
            for (Map.Entry e : ((Message)value).getAllFields().entrySet()) {
                this.asXml(sb, (Descriptors.FieldDescriptor)e.getKey(), e.getValue());
            }
            sb.append("</" + fd.getName() + ">");
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            sb.append("<" + fd.getName() + ">");
            sb.append(((Descriptors.EnumValueDescriptor)value).getName());
            sb.append("</" + fd.getName() + ">");
        } else {
            sb.append("<" + fd.getName() + ">");
            sb.append(OafDecoder.escapeXml(value.toString()));
            sb.append("</" + fd.getName() + ">");
        }
    }

    private static String escapeXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

