/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.hadoop.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.DatasourceOrganizationProtos;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.PersonPersonProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.ProjectOrganizationProtos;
import eu.dnetlib.data.proto.ProjectPersonProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HBaseTableUtils {
    private static final String SEPARATOR = "_";
    private static final Function<TypeProtos.Type, String> typeName = new Function<TypeProtos.Type, String>(){

        public String apply(TypeProtos.Type type) {
            return type.toString();
        }
    };

    public static Set<String> listAllColumns() {
        Sets.SetView union = Sets.union(HBaseTableUtils.listEntities(), HBaseTableUtils.listRelationships());
        return Sets.union((Set)union, HBaseTableUtils.listDedupRelationships());
    }

    public static Set<String> listDedupColumns(Collection<TypeProtos.Type> entityTypes) {
        Set<String> entities = HBaseTableUtils.listEntities(Lists.newArrayList((Iterable)Iterables.transform(entityTypes, typeName)));
        return Sets.union(entities, HBaseTableUtils.listDedupRelationships());
    }

    private static Set<String> listDedupRelationships() {
        HashSet cfs = Sets.newHashSet();
        cfs.add((Object)((Object)RelTypeProtos.RelType.organizationOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.merges));
        cfs.add((Object)((Object)RelTypeProtos.RelType.organizationOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.isMergedIn));
        cfs.add((Object)((Object)RelTypeProtos.RelType.organizationOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedupSimilarity) + SEPARATOR + (Object)((Object)DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.merges));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.isMergedIn));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedupSimilarity) + SEPARATOR + (Object)((Object)DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.merges));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedup) + SEPARATOR + (Object)((Object)DedupProtos.Dedup.RelName.isMergedIn));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.dedupSimilarity) + SEPARATOR + (Object)((Object)DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo));
        return cfs;
    }

    private static Set<String> listEntities(final Collection<String> entityType) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), typeName), (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return entityType.contains(s);
            }
        }));
    }

    public static Set<String> listEntities() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), typeName));
    }

    public static Set<String> listRelationships() {
        HashSet cfs = Sets.newHashSet();
        cfs.add((Object)((Object)RelTypeProtos.RelType.datasourceOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.provision) + SEPARATOR + (Object)((Object)DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.isProvidedBy));
        cfs.add((Object)((Object)RelTypeProtos.RelType.datasourceOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.provision) + SEPARATOR + (Object)((Object)DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.provides));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.coauthorship) + SEPARATOR + (Object)((Object)PersonPersonProtos.PersonPerson.CoAuthorship.RelName.isCoauthorOf));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.authorship) + SEPARATOR + (Object)((Object)PersonResultProtos.PersonResult.Authorship.RelName.isAuthorOf));
        cfs.add((Object)((Object)RelTypeProtos.RelType.personResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.authorship) + SEPARATOR + (Object)((Object)PersonResultProtos.PersonResult.Authorship.RelName.hasAuthor));
        cfs.add((Object)((Object)RelTypeProtos.RelType.projectOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.participation) + SEPARATOR + (Object)((Object)ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.hasParticipant));
        cfs.add((Object)((Object)RelTypeProtos.RelType.projectOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.participation) + SEPARATOR + (Object)((Object)ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.isParticipant));
        cfs.add((Object)((Object)RelTypeProtos.RelType.projectPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.contactPerson) + SEPARATOR + (Object)((Object)ProjectPersonProtos.ProjectPerson.ContactPerson.RelName.isContact));
        cfs.add((Object)((Object)RelTypeProtos.RelType.projectPerson) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.contactPerson) + SEPARATOR + (Object)((Object)ProjectPersonProtos.ProjectPerson.ContactPerson.RelName.hasContact));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultProject) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.outcome) + SEPARATOR + (Object)((Object)ResultProjectProtos.ResultProject.Outcome.RelName.isProducedBy));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultProject) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.outcome) + SEPARATOR + (Object)((Object)ResultProjectProtos.ResultProject.Outcome.RelName.produces));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.similarity) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Similarity.RelName.hasAmongTopNSimilarDocuments));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.similarity) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Similarity.RelName.isAmongTopNSimilarDocuments));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.supplement) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Supplement.RelName.isSupplementedBy));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.supplement) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Supplement.RelName.isSupplementTo));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.part) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Part.RelName.isPartOf));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.part) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.Part.RelName.hasPart));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultResult) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.publicationDataset) + SEPARATOR + (Object)((Object)ResultResultProtos.ResultResult.PublicationDataset.RelName.isRelatedTo));
        cfs.add((Object)((Object)RelTypeProtos.RelType.resultOrganization) + SEPARATOR + (Object)((Object)RelTypeProtos.SubRelType.affiliation) + SEPARATOR + (Object)((Object)ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.isAffiliatedWith));
        return cfs;
    }

    public static enum VolatileColumnFamily {
        dedup,
        dedupPerson;


        public static boolean isVolatile(String columnName) {
            try {
                return VolatileColumnFamily.valueOf(columnName) != null;
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

