package eu.dnetlib.pace.model.gt;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.proto.FieldTypeProtos.DataInfo;
import eu.dnetlib.data.proto.FieldTypeProtos.Qualifier;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.PersonProtos.Person.CoAuthor;
import eu.dnetlib.data.proto.PersonProtos.Person.MergedPerson;
import eu.dnetlib.data.proto.PersonProtos.Person.Metadata;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.lang3.StringUtils;

public class GTAuthorMapper {

	public Oaf map(final GTAuthor gta) {

		final Oaf.Builder oaf = Oaf.newBuilder();

		oaf.setDataInfo(getDataInfo());
		oaf.setLastupdatetimestamp(System.currentTimeMillis());
		oaf.setKind(Kind.entity);
		oaf.setEntity(getOafEntity(gta));

		return oaf.build();
	}

	private OafEntity getOafEntity(final GTAuthor gta) {
		final OafEntity.Builder entity = OafEntity.newBuilder();
		entity.setType(Type.person);
		entity.setId(gta.getId());
		entity.setPerson(getPerson(gta));
		return entity.build();
	}

	private Person getPerson(final GTAuthor gta) {
		final Person.Builder person = Person.newBuilder();

		if (gta.getAuthor() != null) {
			final Person.Metadata.Builder m = Person.Metadata.newBuilder();

			if (StringUtils.isNotBlank(gta.getAuthor().getFullname())) {
				m.setFullname(sf(gta.getAuthor().getFullname()));
			}
			if (StringUtils.isNotBlank(gta.getAuthor().getFirstname())) {
				m.setFirstname(sf(gta.getAuthor().getFirstname()));
			}
			if (StringUtils.isNotBlank(gta.getAuthor().getSecondnames())) {
				m.addSecondnames(sf(gta.getAuthor().getSecondnames()));
			}

			person.setMetadata(m.build());
		}

		person.setAnchor(true);
		person.addAllMergedperson(Iterables.transform(gta.getMerged(), new Function<Author, MergedPerson>() {

			@Override
			public MergedPerson apply(final Author a) {
				final MergedPerson.Builder mp = MergedPerson.newBuilder();
				mp.setId(a.getId());
				mp.setMetadata(getMetadata(a));
				return mp.build();
			}

		}));

		person.addAllCoauthor(Iterables.transform(gta.getCoAuthors(), new Function<eu.dnetlib.pace.model.gt.CoAuthor, CoAuthor>() {

			@Override
			public CoAuthor apply(final eu.dnetlib.pace.model.gt.CoAuthor ca) {
				final CoAuthor.Builder coAuthor = CoAuthor.newBuilder();
				coAuthor.setId(ca.getId());
				if (StringUtils.isNotBlank(ca.getAnchorId())) {
					coAuthor.setAnchorId(ca.getAnchorId());
				}
				coAuthor.setMetadata(getMetadata(ca));
				return coAuthor.build();
			}
		}));

		return person.build();
	}

	private Metadata getMetadata(final Author a) {
		final Metadata.Builder m = Metadata.newBuilder();
		m.setFullname(sf(a.getFullname()));
		if (a.isWellFormed()) {
			m.setFirstname(sf(a.getFirstname()));
			m.addSecondnames(sf(a.getSecondnames()));
		}
		return m.build();
	}

	private DataInfo getDataInfo() {
		final DataInfo.Builder d = DataInfo.newBuilder();
		d.setDeletedbyinference(false);
		d.setInferred(true);
		d.setTrust("0.5");
		d.setInferenceprovenance("dedup-person-groundtruth");
		d.setProvenanceaction(Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename(""));
		return d.build();
	}

	private StringField sf(final String s) {
		final StringField.Builder sf = StringField.newBuilder();
		sf.setValue(s);
		return sf.build();
	}

}
