/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.actionmanager.actions;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AbstractActionSerializer;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import java.lang.reflect.Type;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomicActionSerialiser
extends AbstractActionSerializer
implements JsonSerializer<AtomicAction> {
    private static final Log log = LogFactory.getLog(AtomicActionSerialiser.class);

    public static String toJSON(AtomicAction action) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(AtomicAction.class, (Object)new AtomicActionSerialiser());
        return gson.create().toJson((Object)action);
    }

    public JsonElement serialize(AtomicAction aa, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("TargetColumn", aa.getTargetColumn());
        json.addProperty("TargetColumnFamily", aa.getTargetColumnFamily());
        json.addProperty("TargetRowKey", aa.getTargetRowKey());
        json.addProperty("RawSet", aa.getRawSet());
        json.addProperty("RowKey", aa.getRowKey());
        json.addProperty("ActionType", aa.getActionType().toString());
        json.add("Agent", this.getAgentJSON(aa));
        String base64 = new String(Base64.encodeBase64((byte[])this.getTargetValueJSON(aa).getBytes()));
        json.addProperty("TargetValue", base64);
        return json;
    }

    private JsonElement getAgentJSON(AtomicAction aa) {
        Agent a = aa.getAgent();
        JsonObject json = new JsonObject();
        json.addProperty("Agent.Id", a.getId());
        json.addProperty("Agent.name", a.getName());
        json.addProperty("Agent.type", a.getType().toString());
        return json;
    }

    private String getTargetValueJSON(AtomicAction aa) {
        try {
            return aa.getTargetValue() != null && aa.getTargetValue().length > 0 ? JsonFormat.printToString((Message)OafProtos.Oaf.parseFrom(aa.getTargetValue())) : "";
        }
        catch (InvalidProtocolBufferException e) {
            log.error((Object)"unable to parse proto", (Throwable)e);
            return null;
        }
    }
}

