/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolMessageEnum;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;

public class OafRelDecoder {
    private static final String _ = "_";
    private final OafProtos.OafRel oafRel;

    public static OafRelDecoder decode(OafProtos.OafRel oafRel) {
        return new OafRelDecoder(oafRel);
    }

    private OafRelDecoder(OafProtos.OafRel oafRel) {
        this.oafRel = oafRel;
    }

    public RelTypeProtos.RelType getRelType() {
        return this.oafRel.getRelType();
    }

    public String relTypeName() {
        return this.getRelType().toString();
    }

    public RelTypeProtos.SubRelType getSubRelType() {
        return this.oafRel.getSubRelType();
    }

    public String relSubTypeName() {
        return this.getSubRelType().toString();
    }

    public String getCF() {
        return OafRelDecoder.getCF(this.getRelType(), this.getSubRelType());
    }

    public String getCFQ() {
        return OafRelDecoder.getCFQ(this.getRelType(), this.getSubRelType(), this.getRelClass());
    }

    public static String getCFQ(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType, ProtocolMessageEnum relClass) {
        return OafRelDecoder.getCFQ(relType, subRelType, relClass.getValueDescriptor().getName());
    }

    public static String getCFQ(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType, String relClass) {
        return OafRelDecoder.getCF(relType, subRelType) + _ + relClass;
    }

    public static String getCF(RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType) {
        return (Object)((Object)relType) + _ + (Object)((Object)subRelType);
    }

    public String getRelClass() {
        return this.oafRel.getRelClass();
    }

    public RelDescriptor getRelDescriptor() {
        return new RelDescriptor(this.getCFQ());
    }

    public GeneratedMessage getRel() {
        Descriptors.FieldDescriptor fd = this.oafRel.getDescriptorForType().findFieldByName(this.relTypeName());
        return (GeneratedMessage)this.oafRel.getField(fd);
    }

    public GeneratedMessage getSubRel() {
        GeneratedMessage rel = this.getRel();
        Descriptors.FieldDescriptor fd = rel.getDescriptorForType().findFieldByName(this.relSubTypeName());
        return (GeneratedMessage)rel.getField(fd);
    }

    public RelMetadataProtos.RelMetadata getRelMetadata() {
        GeneratedMessage rel = this.getSubRel();
        Descriptors.FieldDescriptor fd = rel.getDescriptorForType().findFieldByName("relMetadata");
        return fd != null ? (RelMetadataProtos.RelMetadata)rel.getField(fd) : null;
    }

    public OafProtos.OafRel.Builder setClassId(String classid) {
        RelMetadataProtos.RelMetadata.Builder relMetadataBuilder = RelMetadataProtos.RelMetadata.newBuilder(this.getRelMetadata());
        relMetadataBuilder.getSemanticsBuilder().setClassid(classid).setClassname(classid);
        OafProtos.OafRel.Builder builder = OafProtos.OafRel.newBuilder(this.oafRel);
        Descriptors.FieldDescriptor fdRel = this.fd((MessageOrBuilder)this.oafRel, this.relTypeName());
        Message.Builder relBuilder = builder.newBuilderForField(fdRel);
        Descriptors.FieldDescriptor fdSubRel = this.fd((MessageOrBuilder)relBuilder, this.relSubTypeName());
        Message.Builder subRelBuilder = relBuilder.newBuilderForField(fdSubRel).mergeFrom((Message)this.getSubRel());
        subRelBuilder.setField(this.fd((MessageOrBuilder)this.getSubRel(), "relMetadata"), (Object)relMetadataBuilder.build());
        relBuilder.setField(fdSubRel, (Object)subRelBuilder.build());
        builder.setField(fdRel, relBuilder.build());
        return builder.setRelClass(classid);
    }

    public TypeProtos.Type getTargetType(TypeProtos.Type sourceType) {
        switch (this.getRelType()) {
            case datasourceOrganization: {
                return sourceType.equals((Object)TypeProtos.Type.datasource) ? TypeProtos.Type.organization : TypeProtos.Type.datasource;
            }
            case organizationOrganization: {
                return TypeProtos.Type.organization;
            }
            case personPerson: {
                return TypeProtos.Type.person;
            }
            case personResult: {
                return sourceType.equals((Object)TypeProtos.Type.person) ? TypeProtos.Type.result : TypeProtos.Type.person;
            }
            case projectOrganization: {
                return sourceType.equals((Object)TypeProtos.Type.project) ? TypeProtos.Type.organization : TypeProtos.Type.project;
            }
            case projectPerson: {
                return sourceType.equals((Object)TypeProtos.Type.project) ? TypeProtos.Type.person : TypeProtos.Type.project;
            }
            case resultOrganization: {
                return sourceType.equals((Object)TypeProtos.Type.result) ? TypeProtos.Type.organization : TypeProtos.Type.result;
            }
            case resultProject: {
                return sourceType.equals((Object)TypeProtos.Type.result) ? TypeProtos.Type.project : TypeProtos.Type.result;
            }
            case resultResult: {
                return TypeProtos.Type.result;
            }
        }
        throw new IllegalArgumentException("Unknown relationship type: " + this.relTypeName());
    }

    protected Descriptors.FieldDescriptor fd(MessageOrBuilder mb, int fieldNumber) {
        return mb.getDescriptorForType().findFieldByNumber(fieldNumber);
    }

    protected Descriptors.FieldDescriptor fd(MessageOrBuilder mb, String fieldName) {
        return mb.getDescriptorForType().findFieldByName(fieldName);
    }

    public String getCachedTargedId() {
        if (!this.oafRel.hasCachedTarget()) {
            return null;
        }
        OafProtos.OafEntity entity = this.oafRel.getCachedTarget();
        return OafEntityDecoder.decode(entity).getId();
    }

    public String getRelSourceId() {
        return this.oafRel.getSource();
    }

    public String getRelTargetId() {
        return this.oafRel.getTarget();
    }
}

