package eu.dnetlib.msro.workflows.nodes;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;

public class FindComplianceRepositoriesJobNode extends SimpleJobNode {

	private String dbName;

	// The following files are in "dnet-openaireplus-datasource-manager-service" module
	private final Resource sqlSelectDatasourcesTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/getDatasources.sql.st");
	private final Resource xsltFile = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_2_is.xslt");

	private String eprParam = "repoEpr";

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private ResultSetFactory resultSetFactory;

	private static final Log log = LogFactory.getLog(FindComplianceRepositoriesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final Env env) throws Exception {
		final StringTemplate st = new StringTemplate(IOUtils.toString(this.sqlSelectDatasourcesTmpl.getInputStream()));
		// st.setAttribute(
		// "condition",
		// "datasourceclass = 'entityregistry' OR (openairecompatibilityclass IS NOT null AND openairecompatibilityclass != 'UNKNOWN' AND
		// openairecompatibilityclass != 'notCompatible')");
		final String sql = st.toString();

		log.debug("Executing query: " + sql);

		final ResultSet<String> rs = this.serviceLocator.getService(DatabaseService.class).searchSQL(this.dbName, sql);
		final ResultSet<String> mapped = this.resultSetFactory.map(rs, String.class, new ApplyXslt(this.xsltFile));

		env.setAttribute(getEprParam(), mapped);

		return Arc.DEFAULT_ARC;
	}

	public String getDbName() {
		return this.dbName;
	}

	public void setDbName(final String dbName) {
		this.dbName = dbName;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
