package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by claudio on 20/06/16.
 */
public class LoadMappingProfileJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(LoadMappingProfileJobNode.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String profileId;

	private String loadedMappingParam;

	@Override
	protected String execute(final Env env) throws Exception {

		log.info(String.format("loading mapping from: %s", profileId));

		final String xquery = String.format("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']", getProfileId());
		final String xslt = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xquery);

		log.debug(String.format("mapping: %s", xslt));

		if (StringUtils.isBlank(xslt)) {
			throw new IllegalStateException("unable to load mapping from profile: " + getProfileId());
		}

		env.setAttribute(getLoadedMappingParam(), xslt);

		return Arc.DEFAULT_ARC;
	}

	public String getProfileId() {
		return profileId;
	}

	public void setProfileId(final String profileId) {
		this.profileId = profileId;
	}

	public String getLoadedMappingParam() {
		return loadedMappingParam;
	}

	public void setLoadedMappingParam(final String loadedMappingParam) {
		this.loadedMappingParam = loadedMappingParam;
	}
}
