package eu.dnetlib.msro.workflows.nodes.dedup;

import java.io.IOException;
import javax.annotation.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUserActionDbJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(QueryUserActionDbJobNode.class);

	private String db;

	private String sql;
	private String sqlForSize;
	private String xslt;
	private String outputEprParam;

	private String dedupConfigSequence;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		if (StringUtils.isBlank(getDedupConfigSequence())) throw new IllegalArgumentException("empty action set id");

		final String sqlText = String.format(readFromClasspath(getSql()), getDedupConfigSequence());
		log.debug("executing query: " + sqlText);

		final String sqlTextForsize = String.format(StringUtils.isBlank(getSqlForSize()) ? "" : readFromClasspath(getSqlForSize()), getDedupConfigSequence());
		if (!sqlTextForsize.isEmpty()) {
			log.debug("using sql for size: " + sqlTextForsize);
		}

		ResultSet<String> rs = null;

		final DatabaseService dbService = serviceLocator.getService(DatabaseService.class);

		if (StringUtils.isNotBlank(getXslt())) {
			final String xsltText = IOUtils.toString(getClass().getResourceAsStream(getXslt()));

			if (StringUtils.isBlank(getSqlForSize())) {
				rs = dbService.xsltSearchSQL(getDb(), sqlText, xsltText);
			} else {
				rs = dbService.alternativeXsltSearchSQL(getDb(), sqlText, sqlTextForsize, xsltText);
			}
		} else {
			if (StringUtils.isBlank(getSqlForSize())) {
				rs = dbService.searchSQL(getDb(), sqlText);
			} else {
				rs = dbService.alternativeSearchSQL(getDb(), sqlText, sqlTextForsize);
			}
		}

		log.info(String.format("generated resultset '%s', baseURL: %s", rs.getId(), rs.getBaseUrl()));
		env.setAttribute(getOutputEprParam(), rs);

		return Arc.DEFAULT_ARC;
	}

	private String readFromClasspath(final String path) throws IOException {
		return IOUtils.toString(getClass().getResourceAsStream(path));
	}



	public String getDb() {
		return db;
	}

	public void setDb(final String db) {
		this.db = db;
	}

	public String getSql() {
		return sql;
	}

	public void setSql(final String sql) {
		this.sql = sql;
	}

	public String getXslt() {
		return xslt;
	}

	public void setXslt(final String xslt) {
		this.xslt = xslt;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getSqlForSize() {
		return sqlForSize;
	}

	public void setSqlForSize(final String sqlForSize) {
		this.sqlForSize = sqlForSize;
	}

	public String getDedupConfigSequence() {
		return dedupConfigSequence;
	}

	public void setDedupConfigSequence(final String dedupConfigSequence) {
		this.dedupConfigSequence = dedupConfigSequence;
	}
}
