package eu.dnetlib.msro.workflows.nodes.dedup.utils;

import com.google.gson.GsonBuilder;

/**
 * The Class Entity.
 */
public class Entity {

	/** The name. */
	private String name;

	/** The code. */
	private String code;

	/** The label. */
	private String label;

	public Entity() {}

	/**
	 * Instantiates a new entity.
	 *
	 * @param name
	 *            the name
	 * @param code
	 *            the code
	 * @param label
	 *            the label
	 */
	public Entity(final String name, final String code, final String label) {
		super();
		this.setName(name);
		this.setCode(code);
		this.setLabel(label);
	}

	/**
	 * Gets the name.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Gets the code.
	 *
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the label.
	 *
	 * @return the label
	 */
	public String getLabel() {
		return label;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public void setLabel(final String label) {
		this.label = label;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
