package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.List;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetHBaseTableDescriptionJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(GetHBaseTableDescriptionJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("getting table description: '" + getTableName() + "' on cluster: '" + getCluster() + "'");

		final List<String> columns = getServiceLocator().getService(HadoopService.class).describeHbaseTable(getCluster(), getTableName());
		log.debug(String.format("table '%s': " + columns, getTableName()));
		env.setAttribute(getTableColumnsParamName(), asCSV(columns));

		return Arc.DEFAULT_ARC;
	}

}
