package eu.dnetlib.msro.workflows.nodes.hadoop;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;

public class PrepareIISPreprocessingParamsJobNode extends PrepareIISParams {

	private String xqueryWosMDStore;

	private String mdStoreWosParam = "import_wos_mdstore_id";

	private String xqueryDatabaseService;

	private String databaseServiceLocationParam = "import_database_service_location";

	private String xqueryDataciteObjectStore;

	private String dataciteObjectStoreParam = "import_content_datacite_objectstores_csv";

	private String xqueryWosObjectStore;

	private String wosObjectStorePlaintextParam = "import_content_wos_plaintext_objectstores_csv";

	@Override
	protected String execute(final Env env) throws Exception {
		super.prepare(env);

		env.setAttribute(getMdStoreWosParam(), getProfileId(getXqueryWosMDStore()));
		env.setAttribute(getDatabaseServiceLocationParam(), getServiceEndpoint(getXqueryDatabaseService()));

		env.setAttribute(getDataciteObjectStoreParam(), getFilteredObjectStoreCSV(getXqueryDataciteObjectStore()));
		env.setAttribute(getWosObjectStorePlaintextParam(), getProfileId(getXqueryWosObjectStore()));

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryWosMDStore() {
		return this.xqueryWosMDStore;
	}

	@Required
	public void setXqueryWosMDStore(final String xqueryWosMDStore) {
		this.xqueryWosMDStore = xqueryWosMDStore;
	}

	public String getMdStoreWosParam() {
		return this.mdStoreWosParam;
	}

	public void setMdStoreWosParam(final String mdStoreWosParam) {
		this.mdStoreWosParam = mdStoreWosParam;
	}

	public String getXqueryDatabaseService() {
		return this.xqueryDatabaseService;
	}

	@Required
	public void setXqueryDatabaseService(final String xqueryDatabaseService) {
		this.xqueryDatabaseService = xqueryDatabaseService;
	}

	public String getDatabaseServiceLocationParam() {
		return this.databaseServiceLocationParam;
	}

	public void setDatabaseServiceLocationParam(final String databaseServiceLocationParam) {
		this.databaseServiceLocationParam = databaseServiceLocationParam;
	}

	public String getWosObjectStorePlaintextParam() {
		return this.wosObjectStorePlaintextParam;
	}

	public void setWosObjectStorePlaintextParam(final String wosObjectStorePlaintextParam) {
		this.wosObjectStorePlaintextParam = wosObjectStorePlaintextParam;
	}

	public String getXqueryWosObjectStore() {
		return this.xqueryWosObjectStore;
	}

	@Required
	public void setXqueryWosObjectStore(final String xqueryWosObjectStore) {
		this.xqueryWosObjectStore = xqueryWosObjectStore;
	}

	public String getXqueryDataciteObjectStore() {
		return this.xqueryDataciteObjectStore;
	}

	@Required
	public void setXqueryDataciteObjectStore(final String xqueryDataciteObjectStore) {
		this.xqueryDataciteObjectStore = xqueryDataciteObjectStore;
	}

	public String getDataciteObjectStoreParam() {
		return this.dataciteObjectStoreParam;
	}

	public void setDataciteObjectStoreParam(final String dataciteObjectStoreParam) {
		this.dataciteObjectStoreParam = dataciteObjectStoreParam;
	}

}
