package eu.dnetlib.msro.workflows.nodes.index;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

import static java.lang.String.format;

import eu.dnetlib.miscutils.datetime.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import eu.dnetlib.rmi.provision.IndexService;
import org.dom4j.DocumentException;

public class FinalizeIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(FinalizeIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(IndexService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		final String indexDsId = getEnvParam(token.getEnv(), "index_id");

		log.info("preparing blackboard job DELETE_BY_QUERY index: " + indexDsId);

		final String backendId = getBackendId(indexDsId);
		if (StringUtils.isBlank(backendId)) { throw new MSROException("empty index backend Id"); }

		job.setAction("DELETE_BY_QUERY");
		job.getParameters().put("id", indexDsId);
		job.getParameters().put("backend_Id", backendId);
		job.getParameters().put("query", buildQuery(getEnvParam(token.getEnv(), "index.feed.timestamp")));
	}

	private String buildQuery(final String version) {
		final String query =
				String.format("__dsversion:{* TO %s}", DateUtils.getParsedDateField(version));

		log.info("delete by query: " + query);

		return query;
	}

	private String getEnvParam(final Env env, final String name) throws MSROException {
		final String value = env.getAttribute(name, String.class);

		if (StringUtils
				.isBlank(value)) { throw new MSROException(format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name)); }

		return value;
	}

	public String getBackendId(final String indexDsId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		return getServiceLocator().getService(ISLookUpService.class).getResourceProfileByQuery(
				"//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + indexDsId + "']//BACKEND/text()");
	}

}
