package eu.dnetlib.msro.workflows.nodes.index;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.function.UnaryOperator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;

public class OafToIndexRecordFactory {

	private ClassPathResource layoutToRecord;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	public ApplyXslt newTransformer(final String format) throws IOException, TransformerException, ISLookUpException {
		final StreamResult layoutToXsltXslt = getTransformer(format);

		return new ApplyXslt(layoutToXsltXslt.getWriter().toString());
	}

	private StreamResult getTransformer(final String format) throws IOException, TransformerException, ISLookUpException {
		final TransformerFactory factory = TransformerFactory.newInstance();
		final Transformer layoutTransformer = factory.newTransformer(readLayoutToRecord());

		final StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());

		layoutTransformer.setParameter("format", format);
		layoutTransformer.transform(new StreamSource(new StringReader(getLayoutSource(format))), layoutToXsltXslt);
		return layoutToXsltXslt;
	}

	private StreamSource readLayoutToRecord() throws IOException {
		return new StreamSource(new StringReader(IOUtils.toString(layoutToRecord.getInputStream())));
	}

	private String getLayoutSource(final String format) throws ISLookUpException {
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType')[.//NAME='" + format + "']//LAYOUT[@name='index']");
	}

	public ClassPathResource getLayoutToRecord() {
		return layoutToRecord;
	}

	@Required
	public void setLayoutToRecord(final ClassPathResource layoutToRecord) {
		this.layoutToRecord = layoutToRecord;
	}

}
