package eu.dnetlib.msro.workflows.nodes.objectstore;

import java.io.File;

import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.Protocols;

public class PUMAIteratorRepository extends IteratorRepository {

	public PUMAIteratorRepository(final Iterable<File> input, final String repositoryPrefix, final String oaiPrefix) {
		super(input, repositoryPrefix, oaiPrefix);
		// TODO Auto-generated constructor stub
	}

	@Override
	String generateNextElement() {
		try {
			final String inputname = this.input.next().getCanonicalPath();
			final String[] values = inputname.split("/");
			if (values.length > 1) {
				final ObjectStoreFile info = new ObjectStoreFile();
				final String fileName = values[values.length - 1].replace(".pdf", "");
				info.setAccessProtocol(Protocols.None);
				info.setObjectID(fileName);
				info.setDownloadedURL("  ");
				info.setMimeType("pdf");
				info.setURI(inputname);
				return info.toJSON();
			}
		} catch (final Exception e) {
			return null;
		}
		return null;
	}

}
