package eu.dnetlib.msro.workflows.nodes.objectstore;

import java.io.File;

import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.Protocols;

public class RepositoryNoURLIterator extends IteratorRepository {

	public RepositoryNoURLIterator(final Iterable<File> input, final String repositoryPrefix, final String oaiPrefix) {
		super(input, repositoryPrefix, oaiPrefix);
	}

	@Override
	String generateNextElement() {
		try {
			final String inputname = this.input.next().getCanonicalPath();
			final String[] values = inputname.split("/");
			if (values.length > 1) {
				final ObjectStoreFile info = new ObjectStoreFile();
				final String fileName = values[values.length - 1].replace(".xml", "");
				info.setAccessProtocol(Protocols.None);
				// String value = "oai:europepmc.org:" + fileName;
				final String value = this.oaiPrefix + fileName;
				final String resultID = this.repositoryPrefix + "::" + DnetXsltFunctions.md5(value);
				info.setObjectID(resultID);
				info.setMimeType("pdf");
				info.setURI(inputname);
				return info.toJSON();
			}
		} catch (final Exception e) {
			return null;
		}
		return null;
	}

}
